# Elevate to Administrator if needed
If (-NOT ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] "Administrator")) {
    Start-Process powershell.exe "-ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs
    Exit
}

# Enable TLS 1.2
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12

# ----- Download All-in-One Runtime Installer (latest release from GitHub) -----
$repoApi = "https://api.github.com/repos/BloopSmasher/All-in-One-Runtime-Installer/releases/latest"
$headers = @{ "User-Agent" = "RuntimeSetupScript" }
$release = Invoke-RestMethod -Uri $repoApi -Headers $headers

$zipAsset = $release.assets | Where-Object { $_.name -like "*.zip" } | Select-Object -First 1
$zipUrl = $zipAsset.browser_download_url
$zipFile = "All-in-One-Runtime-Installer.zip"
$extractPath = "AllInOneRuntime"

Write-Host "📦 Downloading latest All-in-One-Runtime-Installer..."
Invoke-WebRequest -Uri $zipUrl -OutFile $zipFile

Write-Host "📂 Extracting..."
Expand-Archive -Path $zipFile -DestinationPath $extractPath -Force
Remove-Item $zipFile

# ----- Run the All-in-One Runtime Installer -----
$installerPath = Join-Path $extractPath "All in One Runtime Installer (AutoAdmin).bat"
if (Test-Path $installerPath) {
    Write-Host "🚀 Launching All-in-One Runtime Installer..."
    Start-Process -FilePath $installerPath -Wait
} else {
    Write-Host "⚠️ Could not find All-in-One installer script at: $installerPath" -ForegroundColor Yellow
}

# ----- Install latest WinGet -----
$apiUrl = "https://api.github.com/repos/microsoft/winget-cli/releases/latest"
$assets = (Invoke-RestMethod -Uri $apiUrl -Headers $headers).assets
$wingetUrl = $assets | Where-Object { $_.name -like "*.msixbundle" } | Select-Object -ExpandProperty browser_download_url

Write-Host "⬇️ Installing WinGet..."
Invoke-WebRequest -Uri $wingetUrl -OutFile "winget.msixbundle"
Add-AppxPackage ".\winget.msixbundle"
Remove-Item "winget.msixbundle"

# ----- Install desired apps with WinGet -----
winget install --id Microsoft.PowerShell --source winget --accept-package-agreements --accept-source-agreements
winget install synctrayzor --accept-package-agreements --accept-source-agreements
winget install windirstat --accept-package-agreements --accept-source-agreements
winget install 7zip.7zip --accept-package-agreements --accept-source-agreements
winget install qBittorrent.qBittorrent --accept-package-agreements --accept-source-agreements

# ----- Disable Defender protection features -----
Set-MpPreference -DisableRealtimeMonitoring $true
Set-MpPreference -DisableBehaviorMonitoring $true
Set-MpPreference -DisableBlockAtFirstSeen $true
Set-MpPreference -SignatureDisableUpdateOnStartupWithoutEngine $true

Write-Host "`n✅ All tasks completed successfully." -ForegroundColor Green
