Technique found in https://github.com/Sadzurami/tunnelbroker-proxies/tree/main

# Linux setup
1. Add `net.ipv6.ip_nonlocal_bind=1` to `/etc/sysctl.conf`
2. Reload sysctl with `sysctl -p`
3. Find your IPv6 public subnet using `ip -6 a`. Example: `2a03:b0c0:3:d0::1d4f:1/64`
4. Execute this command and change `YOURIPV6SUBNET` with the subnet found above:
   ```
   /sbin/ip -6 route add local YOUR_IPV6_SUBNET dev lo
   ```
5. Test if the setup works by incrementing the IPv6 address by default, for example from `2a03:b0c0:3:d0::1d4f:2` to `2a03:b0c0:3:d0::1d4f:3`.  
   Then use that address in this command: `curl --interface THEIPV6ADDRESS icanhazip.com`
6. If you get the IPv6 address and a successful response then you are done with the setup!

# Use this new ability in your program
Like shown above you can now send requests using any IPv6 address in your IPv6 range.   
You need to find the ability to change your source address when sending an HTTP request for example.

Here are some example in various languages:
- NodeJS:
```
var https = require('https');
var options = { host:'icanhazip.com',path:'/',localAddress:'A_RANDOM_IPV6_ADDRESS_IN_YOUR_RANGE',family:6 };
callback = function(response) {
  var data = '';
  response.on('data',function(chunk) { data+= chunk; });
  response.on('error',function(error) { console.log("error: "+error.message); });
  response.on('end',function() {
    console.log(data);
  });
}
https.request(options,callback).end();
```
Found in [https://github.com/nodejs/node/issues/4139](https://github.com/nodejs/node/issues/4139#issuecomment-221406802)
- python: https://stackoverflow.com/questions/72784772/how-to-specify-source-ip-address-in-python-requests

You need to implement some kind of rotating logic into your code for picking a random IPv6 address, this can easily be done by looking at some implementation like https://github.com/ycd/ipv6-rotator/blob/main/src/rotator/rotator.rs or using existing librairies: https://www.npmjs.com/package/random-ipv6

The power of being able to do that inside your program is that you are in control of when changing the IPv6 address and you can send multiple requests in a row (async) with different IPv6 addresses for each request.