#!/bin/bash
# Secret service entry needs the account key set to:
account_value=learning_password


# Function to check the input against the stored secret
check_secret() {
    local input="$1"
    local secret_service_account="$2"

    local secret
    secret=$(secret-tool lookup account "$secret_service_account")

    if [[ $? -ne 0 || -z "$secret" ]]; then
        echo -e "\033[31mError: Could not retrieve secret.\033[0m"
        return 1
    fi

    local result=""
    for ((i = 0; i < ${#input}; i++)); do
        if [[ "${input:$i:1}" == "${secret:$i:1}" ]]; then
            result+="\033[32m\033[0m" # Green for correct
        else
            result+="\033[31m\033[0m" # Red for incorrect
        fi
    done

    local len_string=""
    if [[ ${#input} -gt ${#secret} ]]; then
        len_string="\033[33m+$((${#input} - ${#secret}))\033[0m"
    elif [[ ${#input} -lt ${#secret} ]]; then
        len_string="\033[33m-$((${#secret} - ${#input}))\033[0m"
    else
        len_string="\033[32m==\033[0m"
    fi
    
    echo -e "Result ($len_string): $result"
    return 0
}

while true; do
    echo -n "Enter secret (hidden input, Ctrl+C to exit): "
    input=""

    while IFS= read -rsn1 char; do
        if [[ "$char" == "" ]]; then # Enter key
            echo
            break
        fi
        echo -n ""
        input+="$char"
    done

    check_secret "$input" "$account_value"

    echo
done