I wanted to play Sins of the solar Empire 2 with my friends. Proton and Lutris works great for SP, but MP was broke.

First blocker was [forcing](https://steamcommunity.com/app/1575940/discussions/1/7026264603287932608/#c7026264603289995255) the CPU architecture:  (you can also edit this via ctrl+shift+s while in game)

The second was that there were desync issues, which the [community found and fixed](https://steamcommunity.com/app/1575940/discussions/1/7026264603287932608/#c7026264836515783746) for [other games](https://gist.github.com/reneklacan/7825b82723bf0534cbd2eae014e121ca). These desync issues seem to be fairly common with multiplayer games using proton. So you can always try this and copy the backup files back (.bak) if it didn't work. This version adds sha256 checksums of the .exe files. If you run into issues with "command not found", try `dos2unix steam_patch_mp_desync.sh` then retry.

The below script is a more agnostic version of the original script to be more generic and work with most games by passing the APP ID

```
chmod +x steam_patch_mp_desync.sh
./steam_patch_mp_desync.sh 111011
```

To get a list of installed apps run it without a app id

```
./steam_patch_mp_desync.sh

Provide a steam ID from below
1493710		Proton Experimental
1575940		Sins of a Solar Empire II
1628350		Steam Linux Runtime 3.0 (sniper)
1782120		ZERO Sievert
1794680		Vampire Survivors
228980		Steamworks Common Redistributables
250900		The Binding of Isaac: Rebirth
2805730		Proton 9.0
2828860		The Forever Winter
427520		Factorio
469600		Legion TD 2


example for 'Legion TD 2' would be ./steam_patch_mp_desync.sh
```

For deck users just override the `STEAM_USER` variable while running it if it doesn't default to the right user.
```
STEAM_USER=deck ./steam_patch_mp_desync.sh 11011
```

If you have additional drives setup in steam you'll need to set the full path to `steamapps` directory
```
STEAM_DIR="/mnt/games/steam/steamapps" ./steam_patch_mp_desync.sh 11011
```